﻿using AdwEngine.Protocol;
using System;

namespace WebApplication.WebHost
{
    /// <summary>
    /// 服务安装类
    /// </summary>
    public sealed class Setup
    {
        /// <summary>
        /// 构造的应用程序实例
        /// </summary>
        public IApplication Application { get; private set; }

        /// <summary>
        /// Build Application
        /// </summary>
        /// <returns></returns>
        public static Setup Build()
        {
            //set configuration file base path
            //设定配置文件基础路径
            Adf.ConfigHelper.PATH_ROOT = Adf.ConfigHelper.FindConfigPath();

            //set controller assembly and namespace of controller directory
            //指定控制器程序集及控制器目录的名称空间
            var classAssembly = typeof(Setup).Assembly;

            //create web application instance for AdwEngine.Driver
            //创建以AdwEngine.Driver驱动的网站应用实例
            var application = AdwEngine.WebHost.ApplicationUtil.RegisterApplication(typeof(AdwEngine.Driver.Application));

            //
            //application.Configuration.AuthenticationMode = 1;

            //load static processor
            //装载静态文件处理器
            AdwEngine.WebHost.ApplicationUtil.LoadStaticProcessors(application);

            //register error handler
            //注册异常处理器
            //application.Configuration.ErrorHandler = new ErrorHandler();

            //register service di
            //注册服务
            LoadService(application);

            //注册模块
            LoadModule(application);

            //注册Before
            LoadBefore(application);

            //注册After
            LoadAfter(application);

            //注册Clean
            LoadClean(application);

            //register static
            //注册静态文件路由(覆盖所有非mapping路径文件)
            application.Configuration.Routes.Add(new AdwEngine.WebHost.Route("*", new AdwEngine.WebHost.StaticHandler()));

            //register route map
            //注册路由映射
            AdwEngine.WebHost.ApplicationUtil.Mapping(application, classAssembly);



            var setup = new Setup();
            setup.Application = application;
            return setup;
        }

        /// <summary>
        /// 启动服务
        /// </summary>
        /// <returns></returns>
        public Setup Start()
        {
            var application = this.Application;

            //start web application
            //启动应用实例
            application.Start();

            return this;
        }

        /// <summary>
        /// 等待控制命令
        /// </summary>
        /// <returns></returns>
        public Setup Wait()
        {
            var application = this.Application;

            //wait application next control command
            //等待应用的下一步控制命令
            AdwEngine.WebHost.ApplicationUtil.WaitCommand(application);

            return this;
        }

        /// <summary>
        /// 启用视图模式
        /// </summary>
        /// <returns></returns>
        public Setup View()
        {
            /*
             *
             *  NUGET IMPORT
             *  
             *  AdwEngine.Driver
             *  AdwEngine.WebHost
             *  AdwEngine.Liquid
             *
             */

            var application = this.Application;

            //register view engine
            //注册模板引擎
            AdwEngine.Liquid.ViewEngine.CreateEngine(application);

            //load entity and model type
            //导入实体与模型类型
            //AdwEngine.Liquid.ViewEngine.LoadModel("Entity", "Entity");
            AdwEngine.Liquid.ViewEngine.LoadModel("WebApplication", "WebApplication.Model");

            //
            return this;
        }

        /// <summary>
        /// 启用API模式
        /// </summary>
        /// <returns></returns>
        public Setup Api()
        {
            var application = this.Application;

            return this;
        }


        /// <summary>
        /// 加载页面前置规则
        /// </summary>
        /// <param name="application"></param>
        private static void LoadBefore(IApplication application)
        {
            ////注册OneContext初始
            //application.Configuration.Befores.Add(new AdwEngine.WebHost.Rule("*", new WebHost.Befores.OneContextBefore()));
            ////注册全局视图变量
            //application.Configuration.Befores.Add(new AdwEngine.WebHost.Rule("*", new WebHost.Befores.ViewEnvironmentBefore()));
            ////注册授权判定处理器,限制访问
            //application.Configuration.Befores.Add(new AdwEngine.WebHost.Rule("*", new WebHost.Befores.UserAuthorizationBefore()));
        }

        /// <summary>
        /// 加载页面后置规则 
        /// </summary>
        /// <param name="application"></param>
        private static void LoadAfter(IApplication application)
        {
        }

        /// <summary>
        /// 加载页面清理规则
        /// </summary>
        /// <param name="application"></param>
        private static void LoadClean(IApplication application)
        {
            ////注册OneContext清理
            //application.Configuration.Cleans.Add(new AdwEngine.WebHost.Rule("*", new WebHost.Cleans.OneContextClean()));
        }

        /// <summary>
        /// 加载模块
        /// </summary>
        /// <param name="application"></param>
        private static void LoadModule(IApplication application)
        {
            ////添加认证模块
            //application.Configuration.AddModule(new AdwEngine.Session.AuthorizationModule());

            ////添加会话模块, 
            //application.Configuration.AddModule(new AdwEngine.Session.SessionModule());
        }

        /// <summary>
        /// 通过DI容器来管理服务（BLL 业务逻辑）
        /// </summary>
        /// <param name="application"></param>
        private static void LoadService(IApplication application)
        {
            //根据配置文件自动导入
            Adf.DIContainer.Load();

            ////加载业务程序集
            //Adf.DIContainer.AddAssembly("Business");
            ////使用远程服务器提供服务
            ////Adf.DIContainer.AddAssembly("Business.ServiceClient");

            ////在业务程序集中加载DI实例
            //var interfaceNameSpace = "Service.Sys";
            //Adf.DIContainer.LoadInterfaces(interfaceNameSpace);
            //var instanceNameSpace = "Service.Sys";
            //Adf.DIContainer.LoadInstances(instanceNameSpace);

            //添加日志打印
            application.Configuration.InfoPrintList.Add(a =>
            {
                //获取日志书写器
                var info = application.Configuration.LogFactory.GetWriter("info");

                //打印所有DI
                Adf.DIContainer.ForEach((t, o) =>
                {
                    info.WriteTimeLine("DI {0} => {1}", t.FullName, o);
                });
            });
        }
    }
}




//Clean 与 After 的区别在于

//clean 是处理器
//after 是规则， AdwEngint包含三种规则 before,rule,after

//clean 是用于清理的处理器，不受规则（before,rule,after)影响，在规则正常或异常执行后，必然执行。不受 httpContext.NextRule 属性限制。
//after 是执行规则，按（before,rule,after)顺序执行，受 httpContext.NextRule 属性限制和执行链中出现未处理异常时中断影响。

